-- new script file
function OnAfterSceneLoaded(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    
    self.targetLT:LinkToTarget("lTCounter")
  end
end

function OnBeforeDeath(self)
  self.targetLT:TriggerAllTargets()
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
  end
end

function CreateTriggerSources(self)
  self:AddTriggerSource("targetLT")
end
